
##################################################
## Project : Disease ma[ modelling]
## Script purpose: edge perturbation
## Date: 18.08.2020
## Author: Ahmed HEMEDAN
##################################################


library(rJava)
library(RMut)
initJVM("8G")
library(ggplot2)
library(reshape2)
showOpencl()
setOpencl("gpu")

tca_net <- loadNetwork("bipartite_tca.sif")
# generate all possible initial-states each containing 10 Boolean nodes
set <- generateStates(tca, "100")
# generate all possible groups each containing a single edge in the bipartite_tca_bipartite network
tca_edge <- generateGroups(tca, "all", 0, 1)

call_sensitivity <- function(network, set, param) {
  result <- calSensitivity(network, set, param)
  write.csv(result$Group_1,paste0(param,".csv"))
  df <- read.csv(paste0(param,".csv"))
  df <- subset(df, select = -c(X))
  df <- melt(df, id.vars="GroupID")
  # Separate plot
  ggplot(df, aes(GroupID,value)) + 
    geom_point() + 
    stat_smooth() +
    facet_wrap(~variable)
}


### Node-based mutations for the bipartite network
call_sensitivity(tca, set, "edge_removal")
call_sensitivity(tca, set, "edge_attenuation")
call_sensitivity(tca, set, "edge_addition")
call_sensitivity(tca, set, "edge_signswitch")
call_sensitivity(tca, set, "edge_reverse")                






